Attribute VB_Name = "modFunctions"
Option Explicit

Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As Any, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileSection Lib "kernel32" Alias "WritePrivateProfileSectionA" (ByVal lpAppName As String, ByVal lpString As String, ByVal lpFileName As String) As Long
Private Declare Function GetPrivateProfileSection Lib "kernel32" Alias "GetPrivateProfileSectionA" (ByVal lpAppName As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long

Public Enum TimeFormatType
    DaysHoursMinutesSecondsMilliseconds = 0
    DaysHoursMinutesSeconds = 1
    DHMS = 2
    DaysHoursMinutes = 3
    DHMSshort = 4
    All = 5
    All2 = 6
    All3 = 7
End Enum

Public Sub AddC(ByVal RTB As RichTextBox, ParamArray saElements() As Variant)
If frmMain.mnuLOCKMAIN.Checked = True Then Exit Sub
If Len(RTB.text) > 20000 Then
    RTB.text = vbNullString
    AddC frmMain.RTB1, QBColor(7), "Screen was auto-cleared."
End If
Dim i As Integer
    With RTB
        .SelStart = 99999999
        .SelLength = 50000
        .SelColor = &H8000000F
        .SelText = "[" & Format(Time, "hh:mm:ss") & "] "
        .SelStart = 99999999
    End With
    
    For i = LBound(saElements) To UBound(saElements) Step 2
        With RTB
            .SelStart = 99999999
            .SelLength = 0
            .SelColor = saElements(i)
            .SelText = saElements(i + 1) & Left$(vbCrLf, -2 * CLng((i + 1) = UBound(saElements)))
            .SelStart = 99999999
        End With
    Next i
End Sub

Public Sub WriteINI(wiSection$, wiKey$, wiValue$, wiFile$)
    wiFile$ = (App.Path & "\" & wiFile$)
    WritePrivateProfileString wiSection, wiKey, wiValue, wiFile
End Sub

Public Function ReadINI$(riSection$, riKey$, riFile$)
    Dim sRiBuffer$
    Dim sRiValue$
    Dim sRiLong$
    
    riFile$ = (App.Path & "\" & riFile$)
    If Dir(riFile$) <> vbNullString Then
        sRiBuffer = String(255, vbNull)
        sRiLong = GetPrivateProfileString(riSection, riKey, Chr(1), sRiBuffer, 255, riFile)
        If Left(sRiBuffer, 1) <> Chr(1) Then
            sRiValue = Left(sRiBuffer, sRiLong)
            ReadINI = sRiValue
        End If
    Else
        Open riFile$ For Append As #3
        Close #3
        ReadINI = vbNullString
    End If
End Function

Public Sub QAdd(ByVal strMessage As String, Optional ByVal Priority As Byte = 0)
'Commands that should NEVER be issued against itself
    Dim Splt() As String
    Splt() = Split(strMessage, Space(1), 2)
    If UBound(Splt) > 0 Then
        If LCase(Splt(0)) = "/ban" Or LCase(Splt(0)) = "/ignore" Or LCase(Splt(0)) = "/kick" Or LCase(Splt(0)) = "/designate" Then
            If Left$(LCase$(Splt(1)), (Len(ModVars.strReal_Name) + 1)) = LCase$("*" & ModVars.strReal_Name) Then Exit Sub
            If Left$(LCase$(Splt(1)), Len(ModVars.strReal_Name)) = LCase$(ModVars.strReal_Name) Then Exit Sub
        End If
    End If
    
    If Priority = 0 Then
        If Left$(LCase$(strMessage), 5) = "/ban " Then Priority = 2
        If Left$(LCase$(strMessage), 6) = "/kick " Then Priority = 3
        If Left$(LCase$(strMessage), 7) = "/unban " Then Priority = 3
    End If
    If Priority <= 0 Or Priority >= 5 Then Priority = 4
    
    If Len(strMessage) > 224 Then strMessage = Left$(strMessage, 224)
    
    If strMessage <> vbNullString Then
        clsQueue.AddQueue strMessage, Priority
    End If
End Sub

Public Function matches(ByVal uName As String, ByVal Check As String) As Boolean
Call PrepareCheck(Check)
If uName = Empty Then
   matches = False
   Exit Function
End If
If LCase$(uName) Like LCase$(Check) Then matches = True
End Function

Private Sub PrepareCheck(ByRef tocheck As String)
tocheck = Replace(tocheck, "[", "")
tocheck = Replace(tocheck, "]", "")
tocheck = Replace(tocheck, "", "[[]")
tocheck = Replace(tocheck, "", "[]]")
tocheck = Replace(tocheck, "#", "[#]")
tocheck = Replace(tocheck, "-", "[-]")
End Sub

Public Function FormatCount(Count As Long, Optional FormatType As TimeFormatType = 0) As String
    Dim Days As Long, Hours As Long, Minutes As Long, Seconds As Long, Milliseconds As Long
    
    Milliseconds = Count Mod 1000
    Count = Count \ 1000
    Days = Count \ (24& * 3600&)
    If Days > 0 Then Count = Count - (24& * 3600& * Days)
    Hours = Count \ 3600&
    If Hours > 0 Then Count = Count - (3600& * Hours)
    Minutes = Count \ 60
    Seconds = Count Mod 60


    Select Case FormatType
            Case 0


        FormatCount = Days & " days, " & Hours & " hours, " & _
            Minutes & " minutes, " & Seconds & " seconds, " & Milliseconds & _
            " milliseconds"
            Case 1


            FormatCount = Days & " days, " & Hours & " hours, " & _
                Minutes & " minutes, " & Seconds & " seconds"
            Case 2
                
                If Seconds <> 0 Then
                    FormatCount = Seconds & " S "
                End If
                
                If Hours <> 0 Then
                    FormatCount = Hours & " H " & FormatCount
                End If
                
                If Minutes <> 0 Then
                    FormatCount = Minutes & " M " & FormatCount
                End If
                
                If Days <> 0 Then
                    FormatCount = Days & " D " & FormatCount
                End If
            
            Case 3
            
            FormatCount = Days & " days, " & Hours & " hours, " & _
                Minutes & " minutes"
                
            Case 4
            If Days <> 0 Then FormatCount = Days & " Days"
            If Hours <> 0 Then FormatCount = Hours & " Hrs"
            If Minutes <> 0 Then FormatCount = Minutes & " Min"
            If Seconds >= 0 Then FormatCount = Seconds & " Sec"


            Case 5
            If Days <> 0 Then
                    FormatCount = Days & " days, " & Hours & " hours, " & _
                    Minutes & " minutes, " & Seconds & " seconds"
                    Exit Function
            End If
            If Hours <> 0 Then
                    FormatCount = Hours & " hours, " & _
                    Minutes & " minutes, " & Seconds & " seconds"
                    Exit Function
            End If
            If Minutes <> 0 Then
                    FormatCount = Minutes & " minutes, " & Seconds & " seconds"
                    Exit Function
            End If
            If Seconds >= 0 Then
                    FormatCount = Seconds & " seconds"
                    Exit Function
            End If
            
            Case 6
            If Days <> 0 Then
                    FormatCount = Days & " days, " & Hours & " hours, " & _
                    Minutes & " minutes, " & Seconds & " seconds"
                    Exit Function
            End If
            If Hours <> 0 Then
                    FormatCount = Hours & " hours, " & _
                    Minutes & " minutes, " & Seconds & " seconds"
                    Exit Function
            End If
            If Minutes <> 0 Then
                    FormatCount = Minutes & " minutes, " & Seconds & " seconds"
                    Exit Function
            End If
            If Seconds <> 0 Then
                    FormatCount = Seconds & " seconds"
                    Exit Function
            End If
            If Milliseconds >= 0 Then
                    FormatCount = Milliseconds & " milliseconds"
                    Exit Function
            End If
            
            Case 7
            If Days <> 0 Then
                    FormatCount = Days & " days, " & Hours & " hours, " & _
                    Minutes & " minutes, " & Seconds & " seconds, " & Milliseconds _
                    & " milliseconds."
                    Exit Function
            End If
            If Hours <> 0 Then
                    FormatCount = Hours & " hours, " & _
                    Minutes & " minutes, " & Seconds & " seconds, " & Milliseconds _
                    & " milliseconds."
                    Exit Function
            End If
            If Minutes <> 0 Then
                    FormatCount = Minutes & " minutes, " & Seconds & " seconds, " & Milliseconds _
                    & " milliseconds."
                    Exit Function
            End If
            If Seconds <> 0 Then
                    FormatCount = Seconds & " seconds, " & Milliseconds _
                    & " milliseconds."
                    Exit Function
            End If
            If Milliseconds >= 0 Then
                    FormatCount = Milliseconds & " milliseconds"
                    Exit Function
            End If
End Select
End Function

'Public Function DebugOutput(ByVal sIn As String) As String
'     Dim x1 As Long, y1 As Long
'     Dim iLen As Long, iPos As Long
'     Dim sB As String, ST As String
'     Dim sOut As String
'     Dim Offset As Long, sOffset As String
'
'     'build random string to display
' '    y1 = 256
' '    sIn = String(y1, 0)
' '    For x1 = 1 To 256
' '        Mid(sIn, x1, 1) = Chr(x1 - 1)
' '        'Mid(sIn, x1, 1) = Chr(255 * Rnd())
' '    Next x1
'
'     iLen = Len(sIn)
'     If iLen = 0 Then Exit Function
'     sOut = vbnullstring
'     Offset = 0
'     For x1 = 0 To ((iLen - 1) \ 16)
'         sOffset = Right$("0000" & Hex(Offset), 4)
'         sB = String(48, space(1))
'         ST = "................"
'         For y1 = 1 To 16
'             iPos = 16 * x1 + y1
'             If iPos > iLen Then Exit For
'             Mid(sB, 3 * (y1 - 1) + 1, 2) = Right("00" & Hex(Asc(Mid(sIn, iPos, 1))), 2) & space(1)
'             Select Case Asc(Mid(sIn, iPos, 1))
'             Case 0, 9, 10, 13
'             Case Else
'                 Mid(ST, y1, 1) = Mid(sIn, iPos, 1)
'             End Select
'         Next y1
'         If Len(sOut) > 0 Then sOut = sOut & vbCrLf
'         sOut = sOut & sOffset & ":  "
'         sOut = sOut & sB & "  " & ST
'         Offset = Offset + 16
'     Next x1
'     DebugOutput = sOut
' End Function
